/*
 i-net software provides programming examples for illustration only, without warranty
 either expressed or implied, including, but not limited to, the implied warranties
 of merchantability and/or fitness for a particular purpose. This programming example
 assumes that you are familiar with the programming language being demonstrated and
 the tools used to create and debug procedures. i-net software support professionals
 can help explain the functionality of a particular procedure, but they will not modify
 these examples to provide added functionality or construct procedures to meet your
 specific needs.
  
  i-net software 1998-2013

*/
using System.Collections;
using System.Collections.Generic;


namespace Inet.Viewer.Data
{
    /// <summary>
    /// Stores all important status information of a report. This information is only transmitted with the first page.
    /// </summary>
    public class ReportInfo
    {
        /// <summary>
        /// 
        /// </summary>
        public const string FormatJava = "java";
        /// <summary>
        /// 
        /// </summary>
        public const string FormatPDF = "pdf";
        /// <summary>
        /// 
        /// </summary>
        public const string FormatCSV = "csv";
        /// <summary>
        /// 
        /// </summary>
        public const string FormatData = "data";
        /// <summary>
        /// 
        /// </summary>
        public const string FormatHTM = "htm";
        /// <summary>
        /// 
        /// </summary>
        public const string FormatXLS = "xls";
        /// <summary>
        /// 
        /// </summary>
        public const string FormatODS = "ods";
        /// <summary>
        /// 
        /// </summary>
        public const string FormatPS = "ps";
        /// <summary>
        /// 
        /// </summary>
        public const string FormatRTF = "rtf";
        /// <summary>
        /// 
        /// </summary>
        public const string FormatSVG = "svg";
        /// <summary>
        /// 
        /// </summary>
        public const string FormatTXT = "txt";
        /// <summary>
        /// 
        /// </summary>
        public const string FormatXML = "xml";
        /// <summary>
        /// 
        /// </summary>
        public const string FormatHTML = "html";
        /// <summary>
        /// 
        /// </summary>
        public const string FormatPS1 = "ps1";
        /// <summary>
        /// 
        /// </summary>
        public const string FormatPS2 = "ps2";
        /// <summary>
        /// 
        /// </summary>
        public const string FormatPS3 = "ps3";
        /// <summary>
        /// 
        /// </summary>
        public const string FormatJRA = "jra";
        /// <summary>
        /// 
        /// </summary>
        public const string FormatJAR = "jar";
        /// <summary>
        /// 
        /// </summary>
        public const string FormatJPG = "jpg";
        /// <summary>
        /// 
        /// </summary>
        public const string FormatPNG = "png";
        /// <summary>
        /// 
        /// </summary>
        public const string FormatBMP = "bmp";
        /// <summary>
        /// 
        /// </summary>
        public const string FormatGIF = "gif";

        /// <summary>
        /// Default Constructor
        /// </summary>
        public ReportInfo()
        {
            // by default empty arrayList
            this.Formats = new HashSet<string>();
        }

        /// <summary>
        /// 
        /// </summary>
        public bool IsStrongPDFEncryption { get; set; }

        /// <summary>
        /// 
        /// </summary>
        public bool IsUserPageFormat { get; set; }

        /// <summary>
        /// 
        /// </summary>
        public bool IsFormPrint { get; set; }

        /// <summary>
        /// 
        /// </summary>
        public bool IsPrintingEnabled { get; set; }

        /// <summary>
        /// 
        /// </summary>
        public bool IsClipboardEnabled { get; set; }

        /// <summary>
        /// 
        /// </summary>
        public bool IsExportEnabled { get; set; }

        /// <summary>
        /// 
        /// </summary>
        public bool IsGroupTreeVisible { get; set; }

        /// <summary>
        /// 
        /// </summary>
        public bool IsFontScaling { get; set; }

        /// <summary>
        /// If no export format is available an empty set should be returned
        /// </summary>
        public HashSet<string> Formats { get; set; } 

        /// <summary>
        /// The title of the report
        /// </summary>
        public string Title { get; set; } 

        /// <summary>
        /// Without the file path and without the file extension.
        /// This is used for the export.
        /// </summary>
        public string FileName { get; set; } 

        /// <summary>
        /// 
        /// </summary>
        public bool IsReportSuppressed { get; set; }
    }
}